/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.event;

import com.ibm.hwmca.base.pa.domain.ConsoleAnalysisDomain;
import com.ibm.hwmca.base.pa.fedc.ConsoleFEDCKey;
import com.ibm.hwmca.base.pa.system.ConsoleSystem;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.base.util.SimServer;
import com.ibm.hwmca.fw.domain.DomainManager;
import com.ibm.hwmca.fw.pa.config.EventGeneratorData;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventManager;
import com.ibm.hwmca.fw.pa.problem.ProblemFactory;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.service.system.util.ServiceInterfaces;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.event.CommonLogEventGenerator;
import com.ibm.hwmca.xfw.pa.event.CommonServiceEvent;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import java.io.File;

public class ConsoleLogEventGenerator
extends CommonLogEventGenerator {
    private static final String TRACE_MASKT = "XPACNEGT";
    private static final String TRACE_MASKF = "XPACNEGF";
    private static final String TRACE_MASKD = "XPACNEGD";

    public ConsoleLogEventGenerator(EventGeneratorData eventGeneratorData, ProblemAnalysisEventManager manager) {
        super(eventGeneratorData, manager);
        boolean dumpPresent = false;
        try {
            String jvmDumpPath = BaseFileControl.getFilePath("jvmdumptargetdirectory");
            if (jvmDumpPath != null) {
                File jvmDumpDirectory = new File(jvmDumpPath);
                if (jvmDumpDirectory != null) {
                    File[] jvmDumpFiles = jvmDumpDirectory.listFiles();
                    if (jvmDumpFiles.length > 0) {
                        Trace.trace(TRACE_MASKF, "there is something in the jvm dump dir");
                        dumpPresent = true;
                    } else {
                        Trace.trace(TRACE_MASKF, "nothing in the directory");
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "the directory wasn't found. Nothing to do.");
                }
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "got an exception getting the dfc location.");
            Trace.trace(TRACE_MASKF, "Nothing we can do. Just keep going");
            Trace.trace(TRACE_MASKF, e);
        }
        if (dumpPresent) {
            OffLoadJVMDump jvmDumpThread = new OffLoadJVMDump();
            Thread dumpThread = new Thread(jvmDumpThread);
            dumpThread.setDaemon(true);
            dumpThread.setName("JVM Dump Handler Thread");
            dumpThread.start();
        } else {
            Trace.trace(TRACE_MASKF, "there is no JVM dump to offload");
        }
    }

    protected void setEventSystem(CommonServiceEvent event) {
        ConsoleAnalysisDomain cad = (ConsoleAnalysisDomain)DomainManager.getDomainManager().get(ConsoleAnalysisDomain.CAD_DOMAINID);
        event.setSystem(cad.getConsoleSystem());
    }

    class OffLoadJVMDump
    implements Runnable {
        OffLoadJVMDump() {
        }

        public void run() {
            Trace.trace(ConsoleLogEventGenerator.TRACE_MASKF, "--> offLoadJVMDump()");
            try {
                Trace.trace(ConsoleLogEventGenerator.TRACE_MASKF, "waiting for the JVM to initialize.  ");
                Thread.sleep(120000L);
                Trace.trace(ConsoleLogEventGenerator.TRACE_MASKF, "times up. let's move the dump");
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                File jvmDumpDirectory;
                File[] jvmDumpFiles = null;
                String jvmDumpPath = BaseFileControl.getFilePath("jvmdumptargetdirectory");
                if (jvmDumpPath != null && (jvmDumpDirectory = new File(jvmDumpPath)) != null) {
                    jvmDumpFiles = jvmDumpDirectory.listFiles();
                    for (int i = 0; i < jvmDumpFiles.length; ++i) {
                        String dumpFileName = jvmDumpFiles[i].getAbsolutePath();
                        Trace.trace(ConsoleLogEventGenerator.TRACE_MASKD, "processing file " + dumpFileName);
                        if (dumpFileName.toLowerCase().endsWith("bz2")) continue;
                        Trace.trace(ConsoleLogEventGenerator.TRACE_MASKD, "compressing " + dumpFileName);
                        String[] cmdString = new String[]{"bzip2", "-zvf", dumpFileName};
                        Trace.trace(ConsoleLogEventGenerator.TRACE_MASKF, "Issuing cmd: ");
                        for (int j = 0; j < cmdString.length; ++j) {
                            Trace.trace(ConsoleLogEventGenerator.TRACE_MASKF, "  " + cmdString[j]);
                        }
                        Process process = Runtime.getRuntime().exec(cmdString);
                        boolean dumpRunning = true;
                        while (dumpRunning) {
                            Trace.trace(ConsoleLogEventGenerator.TRACE_MASKD, "step 1");
                            try {
                                Trace.trace(ConsoleLogEventGenerator.TRACE_MASKD, "running the command");
                                process.waitFor();
                                dumpRunning = false;
                                int exitValue = process.exitValue();
                                Trace.trace(ConsoleLogEventGenerator.TRACE_MASKF, "Exit status " + exitValue + " from dumper process ");
                                if (exitValue == 0) continue;
                                Trace.trace(ConsoleLogEventGenerator.TRACE_MASKF, "Exit status " + exitValue + " from dumper process");
                            }
                            catch (InterruptedException e) {}
                        }
                    }
                }
                ConsoleAnalysisDomain cad = (ConsoleAnalysisDomain)DomainManager.getDomainManager().get(ConsoleAnalysisDomain.CAD_DOMAINID);
                ConsoleSystem system = cad.getConsoleSystem();
                ProblemFactory pf = (ProblemFactory)ServiceInterfaces.getFactory(system, "ProblemFactory");
                CommonProblem theProblem = (CommonProblem)pf.createProblem(system);
                theProblem.setPrimaryAnalyzingConsoleSystem(cad.getConsoleSystem());
                theProblem.setFailingSystem(cad.getConsoleSystem());
                String dumpRefcode = "AA32FFFF";
                SimServer simServer = SimServer.getSimServer();
                byte[] platform = simServer.readSim(5);
                if (platform[0] == 4) {
                    Trace.trace(ConsoleLogEventGenerator.TRACE_MASKD, "running on a zHMC. Swap the refcode.");
                    dumpRefcode = "E332FFFF";
                } else if (platform[0] == 2) {
                    Trace.trace(ConsoleLogEventGenerator.TRACE_MASKD, "running on a zHMC. Swap the refcode.");
                    dumpRefcode = "E332FFFF";
                } else if (platform[0] == 1) {
                    Trace.trace(ConsoleLogEventGenerator.TRACE_MASKD, "running on a zSE. Swap the refcode.");
                    dumpRefcode = "E132FFFF";
                }
                theProblem.setRefcode(dumpRefcode);
                theProblem.setExtension("00000000");
                theProblem.setVetoable(false);
                theProblem.setFEDCKey(new ConsoleFEDCKey("AA", "32", dumpRefcode, "00000000"));
                ProblemManager pm = ProblemManager.getProblemManager();
                pm.open(theProblem);
            }
            catch (Exception e) {
                Trace.trace(ConsoleLogEventGenerator.TRACE_MASKF, "caught an exception handling the JVM dump");
                Trace.trace(ConsoleLogEventGenerator.TRACE_MASKF, e);
            }
            Trace.trace(ConsoleLogEventGenerator.TRACE_MASKF, "<-- offLoadJVMDump()");
        }
    }
}

